<?php
if (!defined('ABSPATH')) exit;

class InternalLinksTool_Undo {

  public static function init() {
    // No menus here (main plugin owns menus).
  }

  public static function record_change($run_id, $post_id, $before, $after) {
    if (!class_exists('InternalLinksTool_DB')) return false;

    $run_id = sanitize_text_field((string)$run_id);
    $post_id = (int)$post_id;
    if ($run_id === '' || $post_id <= 0) return false;

    global $wpdb;
    $table = InternalLinksTool_DB::table('changes');

    $ok = $wpdb->insert($table, [
      'run_id' => $run_id,
      'post_id' => $post_id,
      'before_content' => (string)$before,
      'after_content' => (string)$after,
      'created_at' => current_time('mysql'),
    ]);

    return ($ok !== false);
  }

  /**
   * Undo all changes for a given run_id.
   * Returns ['posts_reverted'=>N,'errors'=>M]
   */
  public static function undo_run($run_id) {
    if (!current_user_can('manage_options')) return ['posts_reverted'=>0,'errors'=>0];

    if (!class_exists('InternalLinksTool_DB')) return ['posts_reverted'=>0,'errors'=>0];

    global $wpdb;
    $table = InternalLinksTool_DB::table('changes');

    $run_id = sanitize_text_field((string)$run_id);
    if ($run_id === '') return ['posts_reverted'=>0,'errors'=>0];

    $rows = $wpdb->get_results(
      $wpdb->prepare("SELECT post_id, before_content FROM {$table} WHERE run_id = %s ORDER BY id DESC", $run_id),
      ARRAY_A
    );
    if (!is_array($rows) || empty($rows)) return ['posts_reverted'=>0,'errors'=>0];

    $seen = [];
    $posts_reverted = 0;
    $errors = 0;

    foreach ($rows as $r) {
      $pid = (int)($r['post_id'] ?? 0);
      if ($pid <= 0) continue;
      if (isset($seen[$pid])) continue; // revert each post once (latest snapshot)

      $seen[$pid] = true;

      $before = (string)($r['before_content'] ?? '');
      $res = wp_update_post(['ID' => $pid, 'post_content' => $before], true);

      if (is_wp_error($res)) { $errors++; continue; }

      $posts_reverted++;

      if (class_exists('InternalLinksTool_DB') && method_exists('InternalLinksTool_DB', 'update_content_hash')) {
        InternalLinksTool_DB::update_content_hash($pid);
      }
    }

    return ['posts_reverted'=>$posts_reverted,'errors'=>$errors];
  }
}
