<?php


if (!defined('ABSPATH')) exit;





class InternalLinksTool_Robots {


    


    private static $cache = null;


    


    public static function is_url_allowed($url) {


        $path = self::get_path($url);


        if ($path === null) return true;


        


        $rules = self::get_rules();


        if ($rules === null) return true;


        


        return self::is_path_allowed_by_rules($path, $rules);


    }


    


    private static function get_path($url) {


        $p = wp_parse_url($url);


        if (!is_array($p)) return null;


        $path = $p['path'] ?? '/';


        if ($path === '') $path = '/';


        return $path;


    }


    


    private static function get_rules() {


        if (self::$cache !== null) return self::$cache;


        


        $robots_url = home_url('/robots.txt');


        $res = wp_remote_get($robots_url, ['timeout' => 10]);


        


        if (is_wp_error($res)) { self::$cache = null; return self::$cache; }


        


        $code = (int)wp_remote_retrieve_response_code($res);


        if ($code < 200 || $code >= 300) { self::$cache = null; return self::$cache; }


        


        $body = (string)wp_remote_retrieve_body($res);


        if (trim($body) === '') { self::$cache = null; return self::$cache; }


        


        self::$cache = self::parse_robots($body);


        return self::$cache;


    }


    


    private static function parse_robots($text) {


        $lines = preg_split("/\r\n|\n|\r/", (string)$text);


        $ua_star = false;


        $allow = [];


        $disallow = [];


        


        foreach ($lines as $line) {


            $line = trim($line);


            if ($line === '' || strpos($line, '#') === 0) continue;


            


            $hashPos = strpos($line, '#');


            if ($hashPos !== false) $line = trim(substr($line, 0, $hashPos));


            if ($line === '') continue;


            


            if (stripos($line, 'user-agent:') === 0) {


                $ua = trim(substr($line, strlen('user-agent:')));


                $ua_star = ($ua === '*');


                continue;


            }


            


            if (!$ua_star) continue;


            


            if (stripos($line, 'allow:') === 0) {


                $path = trim(substr($line, strlen('allow:')));


                if ($path !== '') $allow[] = $path;


                continue;


            }


            


            if (stripos($line, 'disallow:') === 0) {


                $path = trim(substr($line, strlen('disallow:')));


                if ($path !== '') $disallow[] = $path;


                continue;


            }


        }


        


        return ['allow' => $allow, 'disallow' => $disallow];


    }


    


    private static function is_path_allowed_by_rules($path, $rules) {


        $allow = $rules['allow'] ?? [];


        $disallow = $rules['disallow'] ?? [];


        


        $bestAllow = '';


        $bestDisallow = '';


        


        foreach ($allow as $a) {


            if ($a !== '' && self::path_matches($path, $a) && strlen($a) > strlen($bestAllow)) $bestAllow = $a;


        }


        foreach ($disallow as $d) {


            if ($d !== '' && self::path_matches($path, $d) && strlen($d) > strlen($bestDisallow)) $bestDisallow = $d;


        }


        


        if ($bestAllow === '' && $bestDisallow === '') return true;


        if (strlen($bestAllow) >= strlen($bestDisallow)) return true;


        return false;


    }


    


    private static function path_matches($path, $rulePath) {


        $pattern = preg_quote($rulePath, '/');


        $pattern = str_replace('\*', '.*', $pattern);


        return (bool)preg_match('/^' . $pattern . '/', $path);


    }


}


