<?php
if (!defined('ABSPATH')) exit;

class InternalLinksTool_Meta_Yoast {

  private static function first_non_empty_meta($post_id, $keys) {
    foreach ($keys as $k) {
      $v = get_post_meta($post_id, $k, true);
      if (is_string($v)) {
        $v = trim($v);
        if ($v !== '') return $v;
      }
    }
    return '';
  }

  public static function get_meta_title($post_id) {
    // Yoast usually uses the underscored keys, but some setups store non-underscored
    return self::first_non_empty_meta($post_id, [
      '_yoast_wpseo_title',
      'yoast_wpseo_title',
      '_yoast_wpseo_title_internal', // rare
    ]);
  }

  public static function get_meta_description($post_id) {
    // Yoast canonical key is _yoast_wpseo_metadesc
    // Some setups/plugins store without underscore
    return self::first_non_empty_meta($post_id, [
      '_yoast_wpseo_metadesc',
      'yoast_wpseo_metadesc',
      '_yoast_wpseo_metadesc_internal', // rare
    ]);
  }

  public static function get_meta_robots($post_id) {
    $noindex  = get_post_meta($post_id, '_yoast_wpseo_meta-robots-noindex', true);
    $nofollow = get_post_meta($post_id, '_yoast_wpseo_meta-robots-nofollow', true);

    // Also try non-underscored variants (rare)
    if ($noindex === '' || $noindex === null) {
      $noindex = get_post_meta($post_id, 'yoast_wpseo_meta-robots-noindex', true);
    }
    if ($nofollow === '' || $nofollow === null) {
      $nofollow = get_post_meta($post_id, 'yoast_wpseo_meta-robots-nofollow', true);
    }

    $parts = [];
    if ((string)$noindex === '1') $parts[] = 'noindex';
    if ((string)$nofollow === '1') $parts[] = 'nofollow';

    $robots_adv = get_post_meta($post_id, '_yoast_wpseo_meta-robots-adv', true);
    if (!is_string($robots_adv) || trim($robots_adv) === '') {
      $robots_adv = get_post_meta($post_id, 'yoast_wpseo_meta-robots-adv', true);
    }

    if (is_string($robots_adv) && trim($robots_adv) !== '') {
      $parts[] = trim($robots_adv);
    }

    return trim(implode(', ', array_filter($parts)));
  }
}
